// ============================================================================
//
// This file contains routines that are handled during the Runtime.
//
// Including creating, display, and handling your object.
// 
// ============================================================================

#define RUNTIME_CPP

// Common Include
#include	"common.h"

extern void StretchObject(LPRDATA rdPtr);

//returns true is flag is on
inline bool FlagOn(UINT Source, UINT Flag)
{
	return (Source | Flag) == Source;
}

// DEBUGGER /////////////////////////////////////////////////////////////////

#if !defined(RUN_ONLY)
// Identifiers of items displayed in the debugger
enum
{
// Example
// -------
//	DB_CURRENTSTRING,
//	DB_CURRENTVALUE,
//	DB_CURRENTCHECK,
//	DB_CURRENTCOMBO
};

// Items displayed in the debugger
WORD DebugTree[]=
{
// Example
// -------
//	DB_CURRENTSTRING|DB_EDITABLE,
//	DB_CURRENTVALUE|DB_EDITABLE,
//	DB_CURRENTCHECK,
//	DB_CURRENTCOMBO,

	// End of table (required)
	DB_END
};

#endif // !defined(RUN_ONLY)


// --------------------
// GetRunObjectDataSize
// --------------------
// Returns the size of the runtime datazone of the object
// 
ushort WINAPI DLLExport GetRunObjectDataSize(fprh rhPtr, LPEDATA edPtr)
{
	return(sizeof(RUNDATA));
}


// ---------------
// CreateRunObject
// ---------------
// The routine where the object is actually created
// 
short WINAPI DLLExport CreateRunObject(LPRDATA rdPtr, LPEDATA edPtr, fpcob cobPtr)
{
	cSurface imageSurface;
	fprh	rhPtr = rdPtr->rHo.hoAdRunHeader;
	// get coordinates
	rdPtr->X = rdPtr->OldX = cobPtr->cobX;
	rdPtr->Y = rdPtr->OldY = cobPtr->cobY;
	rdPtr->rHo.hoX=rdPtr->X;
	rdPtr->rHo.hoY=rdPtr->Y;


	::LockImageSurface (rhPtr->rhIdAppli, edPtr->imgidx, imageSurface, LOCKIMAGE_READBLITONLY);

	// get size
	rdPtr->swidth = rdPtr->oldwidth = imageSurface.GetWidth();
	rdPtr->sheight = rdPtr->oldheight = imageSurface.GetHeight();
	rdPtr->rHo.hoImgWidth = rdPtr->swidth;
	rdPtr->rHo.hoImgHeight = rdPtr->sheight;
	LPSURFACE pProto = NULL;
	int Test = imageSurface.GetDepth();
	if ( GetSurfacePrototype(&pProto, imageSurface.GetDepth(), ST_MEMORYWITHPERMANENTDC, SD_DIB) )
	{
		// OK
		rdPtr->runSurface = new cSurface;
		if (rdPtr->runSurface != NULL)
		{
			rdPtr->runSurface->Create(rdPtr->swidth,rdPtr->sheight,pProto);
			imageSurface.Blit(*rdPtr->runSurface,0,0,BMODE_OPAQUE,BOP_COPY,0);
			
			if(imageSurface.HasAlpha()==true)
			{
				rdPtr->runSurface->CreateAlpha();
				LPBYTE mAlpha=	imageSurface.LockAlpha();
				rdPtr->runSurface->SetAlpha(mAlpha,imageSurface.GetAlphaPitch());
				imageSurface.UnlockAlpha();
			}
		}
	}


	::UnlockImageSurface (imageSurface);
	//set flags
	int nOI = rdPtr->rHo.hoOi;
	LPOI poi = rhPtr->rhApp->m_ois[rhPtr->rhApp->m_oi_handle_to_index[nOI]];

    rdPtr->debugmode = FlagOn(edPtr->Flags,OVLFLAG_DEBUG);
	rdPtr->stretching = FlagOn(edPtr->Flags,OVLFLAG_STRETCH);
	rdPtr->AbsolutePos = FlagOn(edPtr->Flags,OVLFLAG_ABSOLUTE);
	rdPtr->Immediate = FlagOn(edPtr->Flags,OVLFLAG_IMMEDIATE);
	rdPtr->Automatic = FlagOn(edPtr->Flags,OVLFLAG_AUTOMATIC);
	rdPtr->AntiA = (poi->oiHdr.oiInkEffect & EFFECTFLAG_ANTIALIAS) ? TRUE : FALSE;
	rdPtr->RemovePoints = !FlagOn(edPtr->Flags,OVLFLAG_KEEPPTS);
	rdPtr->Mode = ((poi->oiHdr.oiInkEffect & EFFECTFLAG_TRANSPARENT) ? BMODE_TRANSP : BMODE_OPAQUE);
	rdPtr->Effect = (BlitOp)(poi->oiHdr.oiInkEffect & EFFECT_MASK);
	rdPtr->EffectParam =poi->oiHdr.oiInkEffectParam;
	rdPtr->NumPoints = 0;
	rdPtr->SizePoints = POINTS_INTERVAL;
	rdPtr->Points = new POINT[rdPtr->SizePoints];
	rdPtr->BlitFlag=BLTF_COPYALPHA;
	rdPtr->Fade = FALSE;
	rdPtr->FadeInk = float(rdPtr->EffectParam);
	rdPtr->FadeSpeed = 0.0f;

	//stretch!
	if(rdPtr->stretching)
		StretchObject(rdPtr);

	// No errors
	return 0;
}


// ----------------
// DestroyRunObject
// ----------------
// Destroys the run-time object
// 
short WINAPI DLLExport DestroyRunObject(LPRDATA rdPtr, long fast)
{
	if(rdPtr->runSurface != NULL)
	{
		rdPtr->runSurface->Delete();
		delete rdPtr->runSurface;  //C++ tells me I need this, Crag!
	}
	if(rdPtr->Points != NULL)
		delete [] rdPtr->Points;
	// No errors
	return 0;
}


// ----------------
// HandleRunObject
// ----------------
// Called (if you want) each loop, this routine makes the object live
// 
short WINAPI DLLExport HandleRunObject(LPRDATA rdPtr)
{
	if(rdPtr->Fade)
	{
		UpDisp(rdPtr);  //let MMF know we need to update
		rdPtr->FadeInk += rdPtr->FadeSpeed;
		rdPtr->EffectParam = int(rdPtr->FadeInk + 0.5f);
		if(rdPtr->FadeSpeed > 0.0f)
		{
			if(rdPtr->EffectParam >= 128)
			{
				rdPtr->EffectParam = 128;
				rdPtr->Fade = FALSE;
				callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, CND_FADE_DONE, 0);
				if(rdPtr->Fade)
					return 0;
				//else
					return REFLAG_ONESHOT;
			}
		}
		else
		{
			if(rdPtr->EffectParam <= 0)
			{
				rdPtr->EffectParam = 0;
				rdPtr->Fade = FALSE;
				callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, CND_FADE_DONE, 0);
				if(rdPtr->Fade)
					return 0;
				//else
					return REFLAG_ONESHOT;
			}
		}
		return 0;
	}

	return REFLAG_ONESHOT;
}

// ----------------
// DisplayRunObject
// ----------------
// Draw the object in the application screen.
// 
short WINAPI DLLExport DisplayRunObject(LPRDATA rdPtr)
{
	fprh	rhPtr = rdPtr->rHo.hoAdRunHeader;
	LPSURFACE ps = WinGetSurface((int)rhPtr->rhIdEditWin);
		RECT rc;
		rc.left = rdPtr->rHo.hoX - rhPtr->rhWindowX;
		rc.top = rdPtr->rHo.hoY-rhPtr->rhWindowY;
		rc.right = rc.left + rdPtr->rHo.hoImgWidth;
		rc.bottom = rc.top + rdPtr->rHo.hoImgHeight;
	if(rdPtr->debugmode)
	{
		if ( ps != NULL)
		{
			rdPtr->runSurface->Blit(*ps, rc.left,rc.top,rdPtr->Mode, rdPtr->Effect,rdPtr->EffectParam, rdPtr->BlitFlag);
			WinAddZone(rhPtr->rhIdEditWin,&rc);
		}
	}
	// Ok
	return 0;
}

// -------------------
// GetRunObjectSurface
// -------------------
// Implement this function instead of DisplayRunObject if your extension
// supports ink effects and transitions. Note: you can support ink effects
// in DisplayRunObject too, but this is automatically done if you implement
// GetRunObjectSurface (MMF applies the ink effect to the transition).
//
// Note: do not forget to enable the function in the .def file 
// if you remove the comments below.
/*
cSurface* WINAPI DLLExport GetRunObjectSurface(LPRDATA rdPtr)
{
	return rdPtr->runSurface;
}
*/

// -------------------------
// GetRunObjectCollisionMask
// -------------------------
// Implement this function if your extension supports fine collision mode (OEPREFS_FINECOLLISIONS),
// Or if it's a background object and you want Obstacle properties for this object.
//
// Should return NULL if the object is not transparent.
//
// Note: do not forget to enable the function in the .def file 
// if you remove the comments below.
//
/*
cSurface* WINAPI DLLExport GetRunObjectCollisionMask(LPRDATA rdPtr, LPARAM lParam)
{
	// Typical example for active objects
	// ----------------------------------
	// Opaque? collide with box
	if ( (rdPtr->rs.rsEffect & EFFECTFLAG_TRANSPARENT) == 0 )	// Note: only if your object has the OEPREFS_INKEFFECTS option
		return NULL;

	// Transparent? Create mask
	LPSMASK pMask = rdPtr->m_pColMask;
	if ( pMask == NULL )
	{
		if ( rdPtr->m_pSurface != NULL )
		{
			DWORD dwMaskSize = rdPtr->m_pSurface->CreateMask(NULL, lParam);
			if ( dwMaskSize != 0 )
			{
				pMask = (LPSMASK)calloc(dwMaskSize, 1);
				if ( pMask != NULL )
				{
					rdPtr->m_pSurface->CreateMask(pMask, lParam);
					rdPtr->m_pColMask = pMask;
				}
			}
		}
	}

	// Note: for active objects, lParam is always the same.
	// For background objects (OEFLAG_BACKGROUND), lParam maybe be different if the user uses your object
	// as obstacle and as platform. In this case, you should store 2 collision masks
	// in your data: one if lParam is 0 and another one if lParam is different from 0.

	return pMask;
}
*/

// ----------------
// PauseRunObject
// ----------------
// Enters the pause mode
// 
short WINAPI DLLExport PauseRunObject(LPRDATA rdPtr)
{
	// Ok
	return 0;
}


// -----------------
// ContinueRunObject
// -----------------
// Quits the pause mode
//
short WINAPI DLLExport ContinueRunObject(LPRDATA rdPtr)
{
	// Ok
	return 0;
}


// ============================================================================
//
// START APP / END APP / START FRAME / END FRAME routines
// 
// ============================================================================

// -------------------
// StartApp
// -------------------
// Called when the application starts or restarts.
// Useful for storing global data
// 
void WINAPI DLLExport StartApp(mv _far *mV, CRunApp* pApp)
{
	//OutputDebugString("Start app\n");

	// Example
	// -------
	// Delete global data (if restarts application)
//	CMyData* pData = (CMyData*)mV->mvGetExtUserData(pApp, hInstLib);
//	if ( pData != NULL )
//	{
//		delete pData;
//		mV->mvSetExtUserData(pApp, hInstLib, NULL);
//	}
}

// -------------------
// EndApp
// -------------------
// Called when the application ends.
// 
void WINAPI DLLExport EndApp(mv _far *mV, CRunApp* pApp)
{
	//OutputDebugString("End app\n");

	// Example
	// -------
	// Delete global data
//	CMyData* pData = (CMyData*)mV->mvGetExtUserData(pApp, hInstLib);
//	if ( pData != NULL )
//	{
//		delete pData;
//		mV->mvSetExtUserData(pApp, hInstLib, NULL);
//	}
}

// -------------------
// StartFrame
// -------------------
// Called when the frame starts or restarts.
// 
void WINAPI DLLExport StartFrame(mv _far *mV, DWORD dwReserved, int nFrameIndex)
{
	//char tutu[100];
	//wsprintf(tutu, "Start Frame %d\n", nFrameIndex);

	//OutputDebugString(tutu);
}

// -------------------
// EndFrame
// -------------------
// Called when the frame ends.
// 
void WINAPI DLLExport EndFrame(mv _far *mV, DWORD dwReserved, int nFrameIndex)
{
	//char tutu[100];
	//wsprintf(tutu, "End Frame %d\n", nFrameIndex);

	//OutputDebugString(tutu);
}

// ============================================================================
//
// TEXT ROUTINES (if OEFLAG_TEXT)
// 
// ============================================================================

// -------------------
// GetRunObjectFont
// -------------------
// Return the font used by the object.
// 
/*

  // Note: do not forget to enable the functions in the .def file 
  // if you remove the comments below.

void WINAPI GetRunObjectFont(LPRDATA rdPtr, LOGFONT* pLf)
{
	// Example
	// -------
	// GetObject(rdPtr->m_hFont, sizeof(LOGFONT), pLf);
}

// -------------------
// SetRunObjectFont
// -------------------
// Change the font used by the object.
// 
void WINAPI SetRunObjectFont(LPRDATA rdPtr, LOGFONT* pLf, RECT* pRc)
{
	// Example
	// -------
//	HFONT hFont = CreateFontIndirect(pLf);
//	if ( hFont != NULL )
//	{
//		if (rdPtr->m_hFont!=0)
//			DeleteObject(rdPtr->m_hFont);
//		rdPtr->m_hFont = hFont;
//		SendMessage(rdPtr->m_hWnd, WM_SETFONT, (WPARAM)rdPtr->m_hFont, FALSE);
//	}

}

// ---------------------
// GetRunObjectTextColor
// ---------------------
// Return the text color of the object.
// 
COLORREF WINAPI GetRunObjectTextColor(LPRDATA rdPtr)
{
	// Example
	// -------
	return 0;	// rdPtr->m_dwColor;
}

// ---------------------
// SetRunObjectTextColor
// ---------------------
// Change the text color of the object.
// 
void WINAPI SetRunObjectTextColor(LPRDATA rdPtr, COLORREF rgb)
{
	// Example
	// -------
	rdPtr->m_dwColor = rgb;
	InvalidateRect(rdPtr->m_hWnd, NULL, TRUE);
}
*/


// ============================================================================
//
// DEBUGGER ROUTINES
// 
// ============================================================================

// -----------------
// GetDebugTree
// -----------------
// This routine returns the address of the debugger tree
//
LPWORD WINAPI DLLExport GetDebugTree(LPRDATA rdPtr)
{
#if !defined(RUN_ONLY)
	return DebugTree;
#else
	return NULL;
#endif // !defined(RUN_ONLY)
}

// -----------------
// GetDebugItem
// -----------------
// This routine returns the text of a given item.
//
void WINAPI DLLExport GetDebugItem(LPSTR pBuffer, LPRDATA rdPtr, int id)
{
#if !defined(RUN_ONLY)

	// Example
	// -------
/*
	char temp[DB_BUFFERSIZE];

	switch (id)
	{
	case DB_CURRENTSTRING:
		LoadString(hInstLib, IDS_CURRENTSTRING, temp, DB_BUFFERSIZE);
		wsprintf(pBuffer, temp, rdPtr->text);
		break;
	case DB_CURRENTVALUE:
		LoadString(hInstLib, IDS_CURRENTVALUE, temp, DB_BUFFERSIZE);
		wsprintf(pBuffer, temp, rdPtr->value);
		break;
	case DB_CURRENTCHECK:
		LoadString(hInstLib, IDS_CURRENTCHECK, temp, DB_BUFFERSIZE);
		if (rdPtr->check)
			wsprintf(pBuffer, temp, "TRUE");
		else
			wsprintf(pBuffer, temp, "FALSE");
		break;
	case DB_CURRENTCOMBO:
		LoadString(hInstLib, IDS_CURRENTCOMBO, temp, DB_BUFFERSIZE);
		wsprintf(pBuffer, temp, rdPtr->combo);
		break;
	}
*/

#endif // !defined(RUN_ONLY)
}

// -----------------
// EditDebugItem
// -----------------
// This routine allows to edit editable items.
//
void WINAPI DLLExport EditDebugItem(LPRDATA rdPtr, int id)
{
#if !defined(RUN_ONLY)

	// Example
	// -------
/*
	switch (id)
	{
	case DB_CURRENTSTRING:
		{
			EditDebugInfo dbi;
			char buffer[256];

			dbi.pText=buffer;
			dbi.lText=TEXT_MAX;
			dbi.pTitle=NULL;

			strcpy(buffer, rdPtr->text);
			long ret=callRunTimeFunction(rdPtr, RFUNCTION_EDITTEXT, 0, (LPARAM)&dbi);
			if (ret)
				strcpy(rdPtr->text, dbi.pText);
		}
		break;
	case DB_CURRENTVALUE:
		{
			EditDebugInfo dbi;

			dbi.value=rdPtr->value;
			dbi.pTitle=NULL;

			long ret=callRunTimeFunction(rdPtr, RFUNCTION_EDITINT, 0, (LPARAM)&dbi);
			if (ret)
				rdPtr->value=dbi.value;
		}
		break;
	}
*/
#endif // !defined(RUN_ONLY)
}


